---
heading: "Manipulating styles with JavaScript"
---

You don't need to use JavaScript to take advantage of Cleanslate. However, if you do want to manipulate a Cleanslated element with JavaScript, then you must be sure to set the `!important` flag:

    elem.style.color = "red";                             // WON'T work
    elem.style.color = "red !important";                  // WON'T work
    jQuery(elem).css("border", "red");                    // WON'T work
    jQuery(elem).css("border", "red !important");         // WON'T work

    elem.style.setProperty('color', 'red', 'important');  // WILL work
    elem.style.cssText = "border: red !important";        // WILL work
    elem.setAttribute("style", "border: red !important"); // WILL work
    jQuery(elem).attr("style", "border: red !important"); // WILL work

Two jQuery plugins: ['Important'](https://github.com/premasagar/important) and ['style'](https://stackoverflow.com/questions/2655925/how-to-apply-important-using-css/8894528#8894528);
